<?php

namespace app\bootstrap;

use app\core\dispatchers\AsyncEventDispatcher;
use app\core\dispatchers\DeferredEventDispatcher;
use app\core\dispatchers\EventDispatcher;
use app\core\dispatchers\SimpleEventDispatcher;
use app\core\jobs\AsyncEventJobHandler;
use app\core\services\MailTransportFactory;
use yii\base\BootstrapInterface;
use yii\base\ErrorHandler;
use yii\caching\Cache;
use yii\di\Container;
use yii\di\Instance;
use yii\mail\MailerInterface;
use yii\rbac\ManagerInterface;
use yii\queue\Queue;
use Yii;

class SetUp implements BootstrapInterface
{
    public function bootstrap($app): void
    {
        $container = Yii::$container;

        // Регистрируем фабрику транспортов
        $container->setSingleton(MailTransportFactory::class, function () {
            return new MailTransportFactory();
        });

        $container->setSingleton(MailerInterface::class, function () use ($app) {
            return $app->mailer;
        });

        $container->setSingleton(ErrorHandler::class, function () use ($app) {
            return $app->errorHandler;
        });

        $container->setSingleton(Queue::class, function () use ($app) {
            return $app->get('queue');
        });

        $container->setSingleton(Cache::class, function () use ($app) {
            return $app->cache;
        });

        $container->setSingleton(ManagerInterface::class, function () use ($app) {
            return $app->authManager;
        });

        $container->setSingleton(EventDispatcher::class, DeferredEventDispatcher::class);

        $container->setSingleton(DeferredEventDispatcher::class, function (Container $container) {
            return new DeferredEventDispatcher(new AsyncEventDispatcher($container->get(Queue::class)));
        });

        $container->setSingleton(SimpleEventDispatcher::class, function (Container $container) {
            return new SimpleEventDispatcher($container, [
                // UserSignUpRequested::class => [UserSignupRequestedListener::class],
                // UserSignUpConfirmed::class => [UserSignupConfirmedListener::class],
                // UserSmartSignUpRequested::class => [UserSmartSignupRequestedListener::class],
            ]);
        });

        $container->setSingleton(AsyncEventJobHandler::class, [], [
            Instance::of(SimpleEventDispatcher::class)
        ]);
    }
}
