<?php
namespace app\commands;

use app\core\services\backup\BackupManager;
use yii\console\Controller;
use yii\console\ExitCode;

class BackupController extends Controller
{
    private BackupManager $backupManager;

    public function __construct($id, $module, BackupManager $backupManager, $config = [])
    {
        parent::__construct($id, $module, $config);
        $this->backupManager = $backupManager;
    }

    /**
     * Создать ежедневный бэкап (для cron)
     */
    public function actionDaily(): int
    {
        try {
            echo "Создание ежедневного бэкапа...\n";

            $result = $this->backupManager->createBackup(
                'full', // или 'sql' если нужна только БД
                'Ежедневный автоматический бэкап',
                'cron'
            );

            echo "Бэкап создан успешно: {$result['backup_id']}\n";
            echo "Размер: " . round($result['manifest']['database']['size'] / 1024 / 1024, 2) . " MB\n";

            return ExitCode::OK;
        } catch (\Exception $e) {
            echo "Ошибка: " . $e->getMessage() . "\n";
            return ExitCode::SOFTWARE;
        }
    }

    /**
     * Ротация старых бэкапов
     */
    public function actionRotate(): int
    {
        echo "Проверка ротации бэкапов...\n";

        // Просто вызываем создание нового бэкапа, ротация произойдет автоматически
        try {
            $this->backupManager->createBackup('sql', 'Бэкап для ротации', 'cron');
            echo "Ротация выполнена успешно\n";
            return ExitCode::OK;
        } catch (\Exception $e) {
            echo "Ошибка: " . $e->getMessage() . "\n";
            return ExitCode::SOFTWARE;
        }
    }

    /**
     * Список бэкапов (для проверки)
     */
    public function actionList(): int
    {
        $backups = $this->backupManager->listBackups();

        if (empty($backups)) {
            echo "Бэкапы не найдены\n";
            return ExitCode::OK;
        }

        echo "Найдено бэкапов: " . count($backups) . "\n\n";

        foreach ($backups as $backup) {
            $sizeMB = round($backup['size'] / 1024 / 1024, 2);
            echo "ID: {$backup['id']}\n";
            echo "Тип: {$backup['manifest']['type']}\n";
            echo "Дата: {$backup['manifest']['created_at']}\n";
            echo "Размер: {$sizeMB} MB\n";
            echo "---\n";
        }

        return ExitCode::OK;
    }
}
