<?php

namespace app\commands;

use app\core\forms\user\UserCreateForm;
use app\core\helpers\MailHelper;
use app\core\helpers\SettingsHelper;
use app\core\services\user\UserService;
use Yii;
use yii\console\Controller;
use yii\helpers\ArrayHelper;

class UserController extends Controller
{
    private UserService $user_service;

    public function __construct($id, $module, UserService  $user_service, $config = [])
    {
        parent::__construct($id, $module, $config);
        $this->user_service = $user_service;
    }

    public function actionAdd(): void
    {
        $username = $this->prompt('Username:', ['required' => true]);
        $email    = $this->prompt('Email:', ['required' => true]);
        $password = $this->prompt('Password:', ['required' => true]);
        $role     = $this->select('Role:', ArrayHelper::map(Yii::$app->authManager->getRoles(), 'name', 'description'));

        $form           = new UserCreateForm();
        $form->username = $username;
        $form->email    = $email;
        $form->password = $password;

        if ($form->validate()) {
            $this->user_service->create($form, $role);
            $this->stdout('Done!' . PHP_EOL);

            return;
        }

        $this->stdout('Errors found!' . PHP_EOL);
        foreach ($form->errors as $error) {
            $this->stdout(is_string($error) ? $error : $error[0] . PHP_EOL);
        }
    }

    public function actionSend()
    {
        $to = ['test@morework.ru'];
        $mailer = Yii::$app->mailer;

        // 1. Смотрим транспорт
        echo "Transport class: " . get_class($mailer->transport) . "\n";

        // 2. Пробуем подключиться к SMTP
        try {
            $mailer->transport->start();
            echo "SMTP connect: OK\n";
        } catch (\Exception $e) {
            echo "SMTP error: " . $e->getMessage() . "\n";
            return;
        }

        $senderEmail = SettingsHelper::getSetting('from_email', Yii::$app->params['senderEmail']);
        $senderName = SettingsHelper::getSetting('from_name', Yii::$app->params['senderName']);

        // 3. Пробуем отправить
        //$message = $mailer->compose()
        $message = MailHelper::send()->compose()
            ->setFrom([$senderEmail => $senderName])
            ->setTo($to)
            ->setSubject('Тест ' . date('Y-m-d H:i:s'))
            ->setTextBody('Тест тела письма');

        try {
            $result = $message->send();
            echo "Send result: " . ($result ? 'TRUE' : 'FALSE') . "\n";
        } catch (\Exception $e) {
            echo "Send error: " . $e->getMessage() . "\n";
        }
    }
}