<?php

use app\bootstrap\SetUp;
use app\core\components\ApiClient;
use yii\caching\FileCache;
use yii\queue\file\Queue;
use yii\symfonymailer\Mailer;
use zertex\avatar_generator\AvatarGenerator;

$params = array_merge(
    require __DIR__ . '/params.php',
    require __DIR__ . '/params_local.php',
    require __DIR__ . '/version.php'
);
$db = require __DIR__ . '/db.php';

$config = [
    'id' => 'basic-console',
    'basePath' => dirname(__DIR__),
    'bootstrap' => [
        'log',
        'queue',
        SetUp::class,
    ],
    'controllerNamespace' => 'app\commands',
    'aliases' => [
        '@bower' => '@vendor/bower-asset',
        '@npm'   => '@vendor/npm-asset',
        '@tests' => '@app/tests',
    ],
    'components' => [
        'authManager' => [
            'class' => 'yii\rbac\DbManager',
        ],
        'cache' => [
            'class' => FileCache::class,
        ],
        'queue'         => [
            'class' => Queue::class,
            'path' => '@runtime/queue',
        ],
        'avatar'        => [
            'class'              => AvatarGenerator::class,
            'images_folder'      => '@webroot/images/avatars',
            'images_url'         => '@web/images/avatars',
            'size_width'         => 300,            // default: 300
            'font_size'          => 200,             // default: 200
            'salt'               => 'apx_im_salt',        // salt for image file names
            'texture'            => ['sun', 'rain'],   // texture name
            'texture_over_image' => false,
            'text_over_image'    => false,
        ],
        'log' => [
            'targets' => [
                [
                    'class' => 'yii\log\FileTarget',
                    'levels' => ['error', 'warning'],
                ],
            ],
        ],
        'apiClient' => [
            'class' => ApiClient::class,
        ],
        'db' => $db,
        'mailer' => [
            'class' => Mailer::class,
            'transport' => [
                'dsn' => 'smtp://born@krizaris.ru:4220618sS!@krizaris.ru:587?verify_peer=0',
            ],
            'viewPath' => '@app/mail',
            'useFileTransport' => false,
        ],
    ],
    'params' => $params,
    /*
    'controllerMap' => [
        'fixture' => [ // Fixture generation command line.
            'class' => 'yii\faker\FixtureController',
        ],
    ],
    */
];

//if (YII_ENV_DEV) {
//    // configuration adjustments for 'dev' environment
//    $config['bootstrap'][] = 'gii';
//    $config['modules']['gii'] = [
//        'class' => 'yii\gii\Module',
//    ];
//    // configuration adjustments for 'dev' environment
//    // requires version `2.1.21` of yii2-debug module
//    $config['bootstrap'][] = 'debug';
//    $config['modules']['debug'] = [
//        'class' => 'yii\debug\Module',
//        // uncomment the following to add your IP if you are not connecting from localhost.
//        //'allowedIPs' => ['127.0.0.1', '::1'],
//    ];
//}

return $config;
