<?php

use app\bootstrap\SetUp;
use app\core\auth\Identity;
use app\core\components\ApiClient;
use yii\caching\FileCache;
use yii\filters\ContentNegotiator;
use yii\queue\file\Queue;
use yii\rbac\DbManager;
use yii\web\JsonResponseFormatter;
use yii\web\Response;
use zertex\avatar_generator\AvatarGenerator;

$params = array_merge(
    require __DIR__ . '/params.php',
    require __DIR__ . '/params_local.php',
    require __DIR__ . '/version.php'
);
$db = require __DIR__ . '/db.php';

$config = [
    'id' => 'basic',
    'language' => 'ru-RU',
    'basePath' => dirname(__DIR__),
    'bootstrap' => [
        'log',
        'queue',
        SetUp::class,
        [
            'class' => ContentNegotiator::class,
            'formats' => [
                'application/json' => 'json',
                'application/xml' => 'xml',
            ]
        ]
    ],
    'aliases' => [
        '@bower' => '@vendor/bower-asset',
        '@npm'   => '@vendor/npm-asset',
    ],
    'components' => [
        'request' => [
            'enableCsrfValidation' => false,
            'enableCookieValidation' => false,
            'parsers' => [
                'application/json' => 'yii\web\JsonParser',
            ],
        ],
        'response' => [
            'formatters' => [
                Response::FORMAT_JSON => [
                    'class' => JsonResponseFormatter::class,
                    'prettyPrint' => YII_DEBUG,
                    'encodeOptions' => JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE,
                ],
            ],
        ],
        'authManager' => [
            'class' => DbManager::class,
        ],
        'cache' => [
            'class' => FileCache::class,
        ],
        'queue'         => [
            'class' => Queue::class,
            'path' => '@runtime/queue',
        ],
        'avatar'        => [
            'class'              => AvatarGenerator::class,
            'images_folder'      => '@webroot/images/avatars',
            'images_url'         => '@web/images/avatars',
            'size_width'         => 300,            // default: 300
            'font_size'          => 200,             // default: 200
            'salt'               => 'apx_im_salt',        // salt for image file names
            'texture'            => ['sun', 'rain'],   // texture name
            'texture_over_image' => false,
            'text_over_image'    => false,
        ],
        'user'               => [
            'identityClass' => Identity::class,
            'enableAutoLogin' => false,
            'enableSession' => false,
        ],
        'apiClient' => [
            'class' => ApiClient::class,
        ],
        'errorHandler' => [
            'errorAction' => 'site/error',
        ],
        'log' => [
            'traceLevel' => YII_DEBUG ? 3 : 0,
            'targets' => [
                [
                    'class' => 'yii\log\FileTarget',
                    'levels' => ['error', 'warning'],
                ],
            ],
        ],
        'db' => $db,
        'urlManager' => [
            'enablePrettyUrl' => false,
            'enableStrictParsing' => false,
            'showScriptName' => true,
            'rules' => [
//                'POST auth/login' => 'auth/login',
//                'POST auth/get-code' => 'auth/get-code',
//                'POST auth/reset-password' => 'auth/reset-password',
//
//                'GET user/data' => 'user/data',
//                'GET user/list' => 'user/list',
//                'GET user/view' => 'user/view',
//                'POST user/create' => 'user/create',
//                'POST user/update' => 'user/update',
//                'POST user/delete' => 'user/delete',
//                'POST user/repair' => 'user/repair',
//                'POST user/delete-all' => 'user/delete-all',
//                'POST user/set-avatar' => 'user/set-avatar',
//
//                'GET events/list' => 'event/list',
//                'GET events/view' => 'event/view',
//                'GET events/view-by-slug' => 'event/view-by-slug',
//                'GET events/upcoming' => 'event/upcoming',
//                'GET events/past' => 'event/past',
//                'GET events/stats' => 'event/stats',
//
//                'POST events/create' => 'event/create',
//                'POST events/update' => 'event/update',
//                'POST events/publish' => 'event/publish',
//                'POST events/cancel' => 'event/cancel',
//                'POST events/archive' => 'event/archive',
//                'POST events/delete' => 'event/delete',
//                'POST events/upload-image' => 'event/upload-image',
//                'POST events/remove-image' => 'event/remove-image',
            ],
        ],
    ],
    'params' => $params,
];

//if (YII_ENV_DEV) {
//    // configuration adjustments for 'dev' environment
//    $config['bootstrap'][] = 'debug';
//    $config['modules']['debug'] = [
//        'class' => 'yii\debug\Module',
//        // uncomment the following to add your IP if you are not connecting from localhost.
//        //'allowedIPs' => ['127.0.0.1', '::1'],
//    ];
//
//    $config['bootstrap'][] = 'gii';
//    $config['modules']['gii'] = [
//        'class' => 'yii\gii\Module',
//        // uncomment the following to add your IP if you are not connecting from localhost.
//        //'allowedIPs' => ['127.0.0.1', '::1'],
//    ];
//}

return $config;
