<?php

namespace app\controllers;

use app\controllers\ApiController;
use Exception;
use Yii;

class ShopController extends ApiController
{
    public function actionCheck(): array
    {
        $result = Yii::$app->apiClient->fetchToken();

//        $domain = Yii::$app->params['generalDomain'];
//        $url = Yii::$app->params['apiFatherUrl'] . '?r=/site/check';
//
//        $ch = curl_init();
//
//        // Данные для отправки
//        $postData = ['domain' => $domain];
//
//        curl_setopt_array($ch, [
//            CURLOPT_URL => $url,
//            CURLOPT_RETURNTRANSFER => true,
//            CURLOPT_POST => true,
//            CURLOPT_POSTFIELDS => http_build_query($postData), // Формат: domain=example.com
//            CURLOPT_TIMEOUT => 30,
//            CURLOPT_HTTPHEADER => [
//                'Content-Type: application/x-www-form-urlencoded',
//            ],
//        ]);
//
//        $response = curl_exec($ch);
//        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
//
//        if (curl_errno($ch)) {
//            $error = curl_error($ch);
//            curl_close($ch);
//            //throw new \Exception('CURL error: ' . $error);
//            return [
//                'result' => 'error',
//                'error' => 'API недоступен: ' . $error,
//                'http_code' => null
//            ];
//        }
//
//        curl_close($ch);
//
//        // Проверка HTTP кода
//        if ($httpCode !== 200) {
//            return [
//                'result' => 'error',
//                'error' => "Статус API: {$httpCode}",
//                'http_code' => $httpCode,
//                'raw_response' => $response
//            ];
//        }
//
//        // Парсим JSON
//        if (!json_validate($response)) {
//            return [
//                'result' => 'error',
//                'error' => 'Некорректный ответ от API',
//                'http_code' => $httpCode
//            ];
//        }

//        if (isset($response['data']['token']) && isset($response['data']['expires_in'])) {
//            Yii::$app->apiToken->setToken($response['data']['token'], $response['data']['expires_in']);
//        }


        if ($result['result'] != 'success') {
            return $result;
        }

        return [
            'result' => 'success',
            //'status' => $httpCode,
            //'response' => $response,
            //'data' => json_decode($response, true), // если ответ JSON
            //'token' => Yii::$app->apiClient->getToken()
        ];

    }

    public function actionItems(): array
    {
        try {
            return Yii::$app->apiClient->request('GET', 'shop/items');
        } catch (Exception $e) {
            return [
                'result' => 'error',
                'message' => $e->getMessage()
            ];
        }
    }

    public function actionRegister(): array
    {
        $domain = Yii::$app->params['generalDomain'];
        $url = Yii::$app->params['apiFatherUrl'] . '?r=/site/register';

        $ch = curl_init();

        // Данные для отправки
        $postData = ['domain' => $domain];

        curl_setopt_array($ch, [
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_POST => true,
            CURLOPT_POSTFIELDS => http_build_query($postData), // Формат: domain=example.com
            CURLOPT_TIMEOUT => 30,
            CURLOPT_HTTPHEADER => [
                'Content-Type: application/x-www-form-urlencoded',
            ],
        ]);

        $response = curl_exec($ch);
        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);

        if (curl_errno($ch)) {
            $error = curl_error($ch);
            curl_close($ch);
            //throw new \Exception('CURL error: ' . $error);
            return [
                'result' => 'error',
                'error' => 'API недоступен: ' . $error,
                'http_code' => null
            ];
        }

        curl_close($ch);

        // Проверка HTTP кода
        if ($httpCode !== 200) {
            return [
                'result' => 'error',
                'error' => "Статус API: {$httpCode}",
                'http_code' => $httpCode,
                'raw_response' => $response
            ];
        }

        // Парсим JSON
        if (!json_validate($response)) {
            return [
                'result' => 'error',
                'error' => 'Некорректный ответ от API',
                'http_code' => $httpCode
            ];
        }

        return [
            'status' => $httpCode,
            'response' => $response,
            'data' => json_decode($response, true) // если ответ JSON
        ];

    }

    public function actionPaymentCreate(): array
    {
        if (Yii::$app->params['demo']) { // Демо режим
            return [
                'result' => 'error',
                'message' => 'Запрещено в демо режиме'
            ];
        }

        $domain = Yii::$app->params['generalDomain'];
        $id = Yii::$app->request->post('id');

        $result = Yii::$app->apiClient->request('POST', 'payment/create', [
            'id' => $id,
            'domain' => $domain,
            'email' => Yii::$app->user->identity->user->email,
        ]);

        if ($result && $result['payment_url']) {
            $result2 = Yii::$app->apiClient->request('GET', 'payment/gateway-url', [
                'id' => $result['payment']['id'],
                'uid' => $result['user_id']
            ]);

            if ($result2) {
                return [
                    'result' => 'success',
                    'data' => $result2
                ];
            }
        }

//        return [
//            'result' => 'success',
//            'data' => $result
//        ];
        return [
            'result' => 'error',
        ];
    }

    public array $accessRules = [
        'check' => ["admin"], // проверки только админу
        'register' => ["admin"], // проверки только админу
        'items' => ["admin"],
        'payment-create' => ["admin"],
    ];

//    public static function publicActions(): array
//    {
//        return ['check'];
//    }
}