<?php

namespace app\core\components;

use Yii;
use yii\web\ForbiddenHttpException;

trait AccessControlTrait
{
    /**
     * @var array Правила доступа [действие => [роли]]
     * Пример: ['create' => ['admin', 'manager'], 'view' => []]
     */
    public array $accessRules = [];

    /**
     * Проверяет доступ к текущему действию
     */
    protected function checkAccess(): void
    {
        $actionId = Yii::$app->controller->action->id;

        // Если правила не заданы для действия, разрешаем всем
        if (!isset($this->accessRules[$actionId])) {
            return;
        }

        // Проверка авторизации
        if (Yii::$app->user->isGuest) {
            throw new ForbiddenHttpException('Требуется авторизация');
        }

        // Проверка ролей
        $requiredRoles = $this->accessRules[$actionId];
        if (!empty($requiredRoles)) {
            $hasAccess = false;
            foreach ($requiredRoles as $role) {
                if (Yii::$app->user->can($role)) {
                    $hasAccess = true;
                    break;
                }
            }

            if (!$hasAccess) {
                $rolesText = implode(' или ', $requiredRoles);
                throw new ForbiddenHttpException("Требуются права: {$rolesText}");
            }
        }
    }
}