<?php

namespace app\core\components;

use Yii;
use yii\base\Behavior;
use yii\web\Controller;
use Firebase\JWT\JWT;

class JwtAuthBehavior extends Behavior
{
    public function events(): array
    {
        return [
            Controller::EVENT_AFTER_ACTION => 'afterAction',
        ];
    }

    public function afterAction($event)
    {
        $response = Yii::$app->response;
        $user = Yii::$app->user;

        // Если пользователь аутентифицирован и ответ успешный
        if (!$user->isGuest && $response->statusCode < 400) {
            $identity = $user->identity;

            // Получаем секретный ключ
            $secretKey = Yii::$app->params['jwtSecretKey'];

            // Если ключ в формате "base64:..." - декодируем
            if (str_starts_with($secretKey, 'base64:')) {
                $secretKey = base64_decode(substr($secretKey, 7));
            }

            // Время
            $issuedAt = time();
            $expire = $issuedAt + (Yii::$app->params['jwtExpired'] ?? 86400 * 30); // 30 дней по умолчанию

            // Полезная нагрузка (payload)
            $payload = [
                'uid' => $identity->user->id,
                'email' => $identity->user->email,
                'username' => $identity->user->username,
                'iss' => Yii::$app->params['jwtIssuer'] ?? Yii::$app->request->hostName,
                'aud' => Yii::$app->params['jwtAudience'] ?? Yii::$app->request->hostName,
                'iat' => $issuedAt,
                'nbf' => $issuedAt,
                'exp' => $expire,
            ];

            // Генерация нового JWT токена
            $newToken = JWT::encode($payload, $secretKey, 'HS512');

            // Добавляем новый токен в заголовок ответа
            $response->headers->set('X-New-Token', $newToken);
        }

        return $event->result;
    }
}
