<?php

namespace app\core\dispatchers;

use app\core\dispatchers\EventDispatcher;
use yii\base\InvalidConfigException;
use yii\di\Container;
use yii\di\NotInstantiableException;

class SimpleEventDispatcher implements EventDispatcher
{
    private Container $container;
    private array $listeners;

    public function __construct(Container $container, array $listeners)
    {
        $this->container = $container;
        $this->listeners = $listeners;
    }

    /**
     * @throws NotInstantiableException
     * @throws InvalidConfigException
     */
    public function dispatchAll(array $events): void
    {
        foreach ($events as $event) {
            $this->dispatch($event);
        }
    }

    /**
     * @throws NotInstantiableException
     * @throws InvalidConfigException
     */
    public function dispatch($event): void
    {
        $eventName = get_class($event);
        if (array_key_exists($eventName, $this->listeners)) {
            foreach ($this->listeners[$eventName] as $listenerClass) {
                $listener = $this->resolveListener($listenerClass);
                $listener($event);
            }
        }
    }

    /**
     * @throws NotInstantiableException
     * @throws InvalidConfigException
     */
    private function resolveListener($listenerClass): callable
    {
        return [$this->container->get($listenerClass), 'handle'];
    }
}
