<?php

namespace app\core\forms\event;

use app\core\entities\Contact;
use yii\base\Model;

class ContactForm extends Model
{
    public $type;
    public $value;
    public $is_primary;

    public function rules(): array
    {
        return [
            [['type', 'value'], 'required'],
            ['type', 'in', 'range' => array_keys(Contact::getTypes())],
            ['value', 'string', 'max' => 255],
            ['is_primary', 'boolean'],

            // Валидация в зависимости от типа
            ['value', 'email', 'when' => function($model) {
                return $model->type === Contact::TYPE_EMAIL;
            }],
            ['value', 'match', 'pattern' => '/^[\d\s\-\+\(\)]+$/', 'when' => function($model) {
                return $model->type === Contact::TYPE_PHONE;
            }],
        ];
    }

    public function attributeLabels(): array
    {
        return [
            'type' => 'Тип контакта',
            'value' => 'Значение',
            'is_primary' => 'Основной контакт',
        ];
    }
}
