<?php

namespace app\core\forms\event;

use app\core\entities\EventField;
use yii\base\Model;

class EventFieldForm extends Model
{
    public $name;
    public $label;
    public $type;
    public $options = [];
    public $required = false;
    public $sort_order = 0;

    private ?EventField $_field;

    public function __construct(?EventField $field = null, $config = [])
    {
        if ($field) {
            $this->_field = $field;
            $this->name = $field->name;
            $this->label = $field->label;
            $this->type = $field->type;
            $this->options = $field->getOptionsArray() ?? [];
            $this->required = (bool)$field->required;
            $this->sort_order = $field->sort_order;
        }
        parent::__construct($config);
    }

    public function rules(): array
    {
        return [
            [['name', 'label', 'type'], 'required'],
            ['name', 'match', 'pattern' => '/^[a-z_][a-z0-9_]*$/'],
            ['name', 'string', 'max' => 100],
            ['label', 'string', 'max' => 255],
            ['type', 'in', 'range' => array_keys(EventField::getTypes())],
            ['required', 'boolean'],
            ['sort_order', 'integer', 'min' => 0],
            ['options', 'safe'],
        ];
    }

    public function attributeLabels(): array
    {
        return [
            'name' => 'Системное имя',
            'label' => 'Название поля',
            'type' => 'Тип поля',
            'options' => 'Опции (для select)',
            'required' => 'Обязательное поле',
            'sort_order' => 'Порядок сортировки',
        ];
    }

    public function beforeValidate(): bool
    {
        if (parent::beforeValidate()) {
            // Обработка опций для select
            if ($this->type === EventField::TYPE_SELECT && is_array($this->options)) {
                $cleanedOptions = [];
                foreach ($this->options as $key => $value) {
                    if (!empty($value)) {
                        $cleanedOptions[$key] = trim($value);
                    }
                }
                $this->options = $cleanedOptions;
            } else {
                $this->options = null;
            }

            return true;
        }
        return false;
    }
}