<?php

namespace app\core\forms\event;

use app\core\entities\Member;
use yii\base\Model;

class MemberForm extends Model
{
    public $first_name;
    public $last_name;
    public $middle_name;
    public $email;
    public $phone;
    public $company;
    public $position;
    public $city;
    public $country;
    public $bio;
    public $documents = [];
    public $notes;
    public $status;

    private ?Member $_member;

    public function __construct(?Member $member = null, $config = [])
    {
        if ($member) {
            $this->_member = $member;
            $this->first_name = $member->first_name;
            $this->last_name = $member->last_name;
            $this->middle_name = $member->middle_name;
            $this->email = $member->email;
            $this->phone = $member->phone;
            $this->company = $member->company;
            $this->position = $member->position;
            $this->city = $member->city;
            $this->country = $member->country;
            $this->bio = $member->bio;
            $this->documents = $member->getDocumentsArray();
            $this->notes = $member->notes;
            $this->status = $member->status;
        }
        parent::__construct($config);
    }

    public function rules(): array
    {
        return [
            [['first_name', 'last_name'], 'required'],
            [['first_name', 'last_name', 'middle_name'], 'string', 'max' => 100],
            ['email', 'email'],
            ['email', 'string', 'max' => 255],
            ['phone', 'string', 'max' => 50],
            [['company', 'position', 'city', 'country'], 'string', 'max' => 255],
            ['bio', 'string'],
            ['notes', 'string'],
            ['status', 'in', 'range' => array_keys(Member::getStatuses())],
            ['documents', 'safe'],
            [['email', 'phone'], 'default', 'value' => null],
        ];
    }

    public function attributeLabels(): array
    {
        return [
            'first_name' => 'Имя',
            'last_name' => 'Фамилия',
            'middle_name' => 'Отчество',
            'email' => 'Email',
            'phone' => 'Телефон',
            'company' => 'Компания',
            'position' => 'Должность',
            'city' => 'Город',
            'country' => 'Страна',
            'bio' => 'Биография',
            'documents' => 'Документы',
            'notes' => 'Заметки',
            'status' => 'Статус',
        ];
    }

    public function beforeValidate(): bool
    {
        if (parent::beforeValidate()) {
            // Очистка телефонного номера
            if ($this->phone) {
                $this->phone = preg_replace('/[^\d\+]/', '', $this->phone);
            }

            // Преобразование документов в JSON
            if (is_array($this->documents)) {
                $this->documents = array_values(array_filter($this->documents));
            }

            return true;
        }
        return false;
    }
}