<?php

namespace app\core\forms\event;

use app\core\entities\Member;
use yii\base\Model;

class MemberSearchForm extends Model
{
    public $first_name;
    public $last_name;
    public $email;
    public $phone;
    public $company;

    public $search;
    public $status;
    public $event_id;
    public $date_from;
    public $date_to;

    public function rules(): array
    {
        return [
            [['search', 'first_name', 'last_name', 'email', 'phone', 'company'], 'string', 'max' => 255],
            ['status', 'in', 'range' => array_keys(Member::getStatuses())],
            ['event_id', 'string'],
            [['date_from', 'date_to'], 'date', 'format' => 'php:Y-m-d'],
        ];
    }

    public function attributeLabels(): array
    {
        return [
            'search' => 'Поиск',
            'status' => 'Статус',
            'event_id' => 'Мероприятие',
            'date_from' => 'С даты',
            'date_to' => 'По дату',
        ];
    }

    /**
     * Преобразование в фильтр для репозитория
     */
    public function getFilters(): array
    {
        $filters = [];

        if ($this->search) {
            $filters['search'] = $this->search;
        }
        if ($this->status !== null && $this->status !== '') {
            $filters['status'] = $this->status;
        }
        if ($this->event_id) {
            $filters['event_id'] = $this->event_id;
        }
        if ($this->date_from) {
            $filters['date_from'] = $this->date_from;
        }
        if ($this->date_to) {
            $filters['date_to'] = $this->date_to;
        }
        if ($this->first_name) {
            $filters['first_name'] = $this->first_name;
        }
        if ($this->last_name) {
            $filters['last_name'] = $this->last_name;
        }
        if ($this->email) {
            $filters['email'] = $this->email;
        }
        if ($this->phone) {
            $filters['phone'] = $this->phone;
        }
        if ($this->company) {
            $filters['company'] = $this->company;
        }

        return $filters;
    }
}