<?php

namespace app\core\forms\event;

use yii\base\Model;

class NotificationSettingsForm extends Model
{
    public $notify_emails = [];
    public $auto_confirm = true;
    public $success_message;

    public function rules(): array
    {
        return [
            ['notify_emails', 'each', 'rule' => ['email']],
            ['notify_emails', 'default', 'value' => []],
            ['auto_confirm', 'boolean'],
            ['success_message', 'string'],
        ];
    }

    public function attributeLabels(): array
    {
        return [
            'notify_emails' => 'Email для уведомлений',
            'auto_confirm' => 'Автоподтверждение регистраций',
            'success_message' => 'Сообщение после регистрации',
        ];
    }

    public function beforeValidate(): bool
    {
        if (parent::beforeValidate()) {
            // Очистка email списка
            if (is_array($this->notify_emails)) {
                $this->notify_emails = array_values(array_filter(array_map('trim', $this->notify_emails)));
            }

            return true;
        }
        return false;
    }
}