<?php

namespace app\core\forms\event;

use app\core\entities\EventRegistrationField;
use yii\base\Model;

class RegistrationFieldForm extends Model
{
    public $name;
    public $label;
    public $type;
    public $required;
    public $sort_order;
    public $section;
    public $options;
    public $validation_rules;

    public function rules(): array
    {
        return [
            [['name', 'label', 'type'], 'required'],
            ['name', 'match', 'pattern' => '/^[a-z][a-z0-9_]*$/'],
            ['name', 'string', 'max' => 100],
            ['label', 'string', 'max' => 255],
            ['type', 'in', 'range' => array_keys(EventRegistrationField::getTypes())],
            ['required', 'boolean'],
            ['sort_order', 'integer', 'min' => 0],
            ['section', 'in', 'range' => array_keys(EventRegistrationField::getSections())],
            [['options', 'validation_rules'], 'safe'],

            // Валидация опций для select
            ['options', 'validateOptions', 'when' => function($model) {
                return $model->type === EventRegistrationField::TYPE_SELECT;
            }],
        ];
    }

    public function validateOptions($attribute, $params): void
    {
        if (is_array($this->$attribute)) {
            foreach ($this->$attribute as $key => $value) {
                if (empty($value)) {
                    $this->addError($attribute, "Опция #{$key} не может быть пустой");
                }
            }
        }
    }

    public function attributeLabels(): array
    {
        return [
            'name' => 'Системное имя',
            'label' => 'Отображаемое название',
            'type' => 'Тип поля',
            'required' => 'Обязательное поле',
            'sort_order' => 'Порядок',
            'section' => 'Раздел',
            'options' => 'Опции',
            'validation_rules' => 'Правила валидации',
        ];
    }

    public function beforeValidate(): bool
    {
        if (parent::beforeValidate()) {
            // Преобразуем массивы в JSON
            if (is_array($this->options)) {
                $this->options = json_encode($this->options, JSON_UNESCAPED_UNICODE);
            }
            if (is_array($this->validation_rules)) {
                $this->validation_rules = json_encode($this->validation_rules, JSON_UNESCAPED_UNICODE);
            }

            return true;
        }
        return false;
    }
}
