<?php

namespace app\core\forms\event;

use app\core\entities\EventRegistration;
use yii\base\Model;

class RegistrationSearchForm extends Model
{
    public $search;
    public $status;
    public $date_from;
    public $date_to;

    public function rules(): array
    {
        return [
            ['search', 'string', 'max' => 255],
            ['status', 'in', 'range' => array_keys(EventRegistration::getStatuses())],
            [['date_from', 'date_to'], 'date', 'format' => 'php:Y-m-d'],
        ];
    }

    public function attributeLabels(): array
    {
        return [
            'search' => 'Поиск',
            'status' => 'Статус',
            'date_from' => 'С даты',
            'date_to' => 'По дату',
        ];
    }
}
