<?php

namespace app\core\forms\event;

use yii\base\Model;

class RegistrationSettingsForm extends Model
{
    public $requires_approval;
    public $notification_emails;
    public $custom_form;
    public $success_message;

    public function rules(): array
    {
        return [
            [['requires_approval', 'custom_form'], 'boolean'],
            ['notification_emails', 'validateEmails'],
            ['success_message', 'string'],
        ];
    }

    public function validateEmails($attribute, $params): void
    {
        if (is_array($this->$attribute)) {
            foreach ($this->$attribute as $index => $email) {
                if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
                    $this->addError($attribute, "Email #{$index} имеет неверный формат");
                }
            }
        }
    }

    public function attributeLabels(): array
    {
        return [
            'requires_approval' => 'Требуется подтверждение регистрации',
            'notification_emails' => 'Email для уведомлений',
            'custom_form' => 'Кастомная форма регистрации',
            'success_message' => 'Сообщение после регистрации',
        ];
    }

    public function beforeValidate(): bool
    {
        if (parent::beforeValidate()) {
            // Преобразуем emails в JSON если это массив
            if (is_array($this->notification_emails)) {
                // Убираем пустые значения
                $this->notification_emails = array_filter($this->notification_emails);
                $this->notification_emails = array_values($this->notification_emails);

                if (!empty($this->notification_emails)) {
                    $this->notification_emails = json_encode($this->notification_emails, JSON_UNESCAPED_UNICODE);
                } else {
                    $this->notification_emails = null;
                }
            }

            return true;
        }
        return false;
    }

    public function getEmailsArray(): array
    {
        if (is_string($this->notification_emails)) {
            return json_decode($this->notification_emails, true) ?: [];
        }

        return is_array($this->notification_emails) ? $this->notification_emails : [];
    }
}
