<?php
namespace app\core\forms\settings;

use yii\base\Model;

class SettingsMailForm extends Model
{
    public ?string $method = null;
    public ?string $encryption = null;
    public ?string $host = null;
    public ?string $port = null;
    public ?string $username = null;
    public ?string $password = null;

    public function rules(): array
    {
        return [
            [['method'], 'required'],
            ['method', 'in', 'range' => ['smtp', 'sendmail', 'php']],


            [['method', 'encryption', 'host', 'username'], 'string', 'max' => 100],
            [['password'], 'string', 'max' => 255],
            ['port', 'integer', 'min' => 1, 'max' => 65535],
            ['encryption', 'in', 'range' => ['tls', 'ssl', '']],
            ['method', 'default', 'value' => 'smtp'],
            ['encryption', 'default', 'value' => 'tls'],
            ['port', 'default', 'value' => '587'],
        ];
    }

    public function afterValidate(): void
    {
        parent::afterValidate();

        // Дополнительная логическая валидация
        if ($this->method === 'smtp') {
            if (empty($this->host)) {
                $this->addError('host', 'Необходимо указать сервер');
            }
            if (empty($this->port)) {
                $this->addError('port', 'Необходимо указать порт');
            }
            if (empty($this->username)) {
                $this->addError('username', 'Необходимо указать имя пользователя');
            }
        }
    }
}
