<?php
namespace app\core\forms\user;

use app\core\entities\User;
use yii\base\Model;

class UserCreateForm extends Model
{
    public ?string $username = '';
    public ?string $email = '';
    public ?string $password = '';

	public function rules(): array
	{
		return [
			[['username', 'email', 'password'], 'required', 'message' => 'Необходимо заполнить'],
            ['email', 'trim'],
			['email', 'email', 'message' => 'Некорректный e-mail адрес'],
            ['username', 'string', 'max' => 100, 'tooLong' => 'Максимум 100 символов'],
			['email', 'string', 'max' => 150, 'tooLong' => 'Максимум 150 символов'],
			[['email'], 'unique', 'targetClass' => User::class, 'message' => 'Пользователь с таким e-mail уже добавлен'],
			['password', 'string', 'min' => 10, 'tooShort' => 'Минимум 10 символов'],
		];
	}
}
