<?php
namespace app\core\forms\user;

use app\core\entities\User;
use Yii;
use yii\base\Model;
use yii\helpers\ArrayHelper;

class UserForm extends Model
{
    public ?string $username = '';
    public ?string $email = '';
    public ?string $password = '';
    public ?string $role = '';
    public ?string $status = '';

    public User $_user;

	public function __construct(User $user = null, $config = [])
	{
		if ($user) {
			$this->username = $user->username;
			$this->email    = $user->email;
			$roles          = Yii::$app->authManager->getRolesByUser( $user->id );
			$this->role     = $roles ? reset( $roles )->name : null;
            $this->status   = $user->status;
			$this->_user    = $user;
		}
		parent::__construct($config);
	}

	public function rules(): array
	{
		return [
			[['username', 'email', 'role'], 'required', 'message' => 'Необходимо заполнить'],
            ['email', 'trim'],
			['email', 'email', 'message' => 'Некорректный e-mail адрес'],
            [['username', 'status'], 'string', 'max' => 100, 'tooLong' => 'Максимум 100 символов'],
			['email', 'string', 'max' => 150, 'tooLong' => 'Максимум 150 символов'],
			[['email'], 'unique', 'targetClass' => User::class, 'filter' => isset($this->_user->id) ? ['<>', 'id', $this->_user->id] : null ],
			['password', 'string', 'min' => 10, 'tooShort' => 'Минимум 10 символов'],
		];
	}

    public function rolesList(): array
    {
        return ArrayHelper::map(Yii::$app->authManager->getRoles(), 'name', 'description');
    }
}
