<?php

namespace app\core\helpers;

use app\core\entities\Event;
use app\core\entities\EventField;

class EventHelper
{
    public static function getColors(): array
    {
        return [
          'dark' => [
              // Красные оттенки
              '#EF4444', '#DC2626', '#B91C1C',
              // Оранжевые оттенки
              '#F97316', '#EA580C', '#C2410C',
              // Желтые/золотые оттенки
              '#EAB308', '#CA8A04', '#A16207',
              // Зеленые оттенки
              '#22C55E', '#16A34A', '#15803D',
              // Бирюзовые оттенки
              '#06B6D4', '#0891B2', '#0E7490',
              // Синие оттенки
              '#3B82F6', '#1D4ED8', '#1E40AF',
              // Фиолетовые оттенки
              '#8B5CF6', '#7C3AED', '#6D28D9',
              // Розовые/пурпурные оттенки
              '#EC4899', '#DB2777', '#BE185D',
              // Коричневые/терракотовые оттенки
              '#B45309', '#92400E', '#78350F',
              // Серые оттенки (нейтральные)
              '#6B7280', '#4B5563', '#374151'
          ],
          'light' => [
              // Красные оттенки (светлые)
              '#FEE2E2', '#FECACA', '#FCA5A5',
              // Оранжевые оттенки
              '#FFEDD5', '#FED7AA', '#FDBA74',
              // Желтые оттенки
              '#FEF3C7', '#FDE68A', '#FCD34D',
              // Зеленые оттенки
              '#DCFCE7', '#BBF7D0', '#86EFAC',
              // Бирюзовые оттенки
              '#CFFAFE', '#A5F3FC', '#67E8F9',
              // Синие оттенки
              '#DBEAFE', '#BFDBFE', '#93C5FD',
              // Фиолетовые оттенки
              '#EDE9FE', '#DDD6FE', '#C4B5FD',
              // Розовые оттенки
              '#FCE7F3', '#FBCFE8', '#F9A8D4',
              // Коричневые/бежевые оттенки
              '#FEF3C7', '#FDE68A', '#FCD34D',
              // Нейтральные оттенки
              '#F3F4F6', '#E5E7EB', '#D1D5DB'
          ]
        ];
    }

    public static function getBaseFields(): array
    {
        return [
            'first_name', 'last_name', 'middle_name',
            'email', 'phone', 'company', 'position',
            'city', 'country'
        ];
    }

    public static function fieldsToCustomObjects(Event $event, array $fields): array
    {
        $result = [];

        // Оставляем только кастомные поля
        $customFields = array_diff_key($fields, array_flip(self::getBaseFields()));

        // Создаем массив кастомных полей с названием
        foreach ($customFields as $field => $value) {
            $field_obj = EventField::find()->andWhere(['event_id' => $event->id, 'name' => $field])->one();
            $result[$field] = [
                'label' => $field_obj ? $field_obj->label : $field,
                'value' => $value,
                'type' => $field_obj?->type,
            ];
        }
        return $result;
    }
}