<?php

namespace app\core\helpers;

class FileHelper extends \yii\helpers\FileHelper
{
    /**
     * Получить дату создания самого нового файла в папке
     * @param string $path Путь к папке
     * @return int|null Дата в формате Y-m-d H:i:s или null если файлов нет
     */
    public static function getNewestFileDate(string $path): int|null
    {
        if (!is_dir($path)) {
            return null;
        }

        $files = array_diff(scandir($path), ['.', '..']);
        $newestTimestamp = 0;
        $newestFile = null;

        foreach ($files as $file) {
            $fullPath = $path . '/' . $file;

            if (file_exists($fullPath)) {
                print_r($fullPath); die;
            }

            // Проверяем только файлы, пропускаем папки
            if (is_file($fullPath)) {
                $fileTime = filemtime($fullPath); // Время последнего изменения
                if ($fileTime > $newestTimestamp) {
                    $newestTimestamp = $fileTime;
                    $newestFile = $fullPath;
                }
            }
        }

        if ($newestTimestamp > 0) {
            return $newestTimestamp;
        }

        return null;
    }

    public static function getNewestFolderDate($path)
    {
        if (!is_dir($path)) {
            return null;
        }

        $items = scandir($path);
        $newestTimestamp = 0;
        $newestFolder = null;

        foreach ($items as $item) {
            if ($item === '.' || $item === '..') {
                continue;
            }

            $fullPath = $path . '/' . $item;

            // Проверяем только ПАПКИ
            if (is_dir($fullPath)) {
                $folderTime = filemtime($fullPath);

                if ($folderTime > $newestTimestamp) {
                    $newestTimestamp = $folderTime;
                    $newestFolder = $fullPath;
                }
            }
        }

        if ($newestTimestamp > 0) {
            return $newestTimestamp;
        }

        return null;
    }
}