<?php
namespace app\core\helpers;

use app\core\entities\Event;
use app\core\entities\EventField;
use app\core\entities\Member;
use app\core\entities\User;
use Yii;

class SerializeHelper
{
    public static function serializeListEvents(Event $event): array
    {
        $registration_count = Member::find()->andWhere(['event_id' => $event->id])->count();
        //$has_available_seats = !$event->max_participants || ($event->max_participants && $event->max_participants - $registration_count);
        //$available_seats = !$event->max_participants ? null : $event->max_participants - $registration_count;

        return [
            'id' => $event->id,
            'title' => $event->title,
            'status' => $event->status,
            'type' => $event->type,
            'image' => $event->image,
            'start_date' => $event->start_date,
            'end_date' => $event->end_date,
            'registration_start' => $event->registration_start,
            'registration_end' => $event->registration_end,
            'max_participants' => $event->max_participants,
            'price' => $event->price,
            'currency' => $event->currency,
            //'available_seats' => $available_seats,
            //'has_available_seats' => $has_available_seats,
            'has_available_seats' => $event->hasAvailableSeats(),
            'available_seats' => $event->getAvailableSeats(),
            'registration_open' => $event->isRegistrationOpen(),
            'registration_count' => $registration_count,
            'color' => $event->color,
            'date' => [
                'created' => DateHelper::formatApi($event->created_at),
                'updated' => DateHelper::formatApi($event->updated_at),
                'created_stamp' => $event->created_at,
                'updated_stamp' => $event->updated_at,
            ],
            'author' => $event->user->username,
        ];
    }

    public static function serializeEvent(Event $event): array
    {
        $registration_count = Member::find()->andWhere(['event_id' => $event->id])->count();
       // $has_available_seats = !$event->max_participants || ($event->max_participants && $event->max_participants - $registration_count);
       // $available_seats = !$event->max_participants ? null : $event->max_participants - $registration_count;

        return [
            'id' => $event->id,
            'title' => $event->title,
            'slug' => $event->slug,
            'description' => $event->description,
            'short_description' => $event->short_description,
            'content' => $event->content,
            'status' => $event->status,
            'type' => $event->type,
            'location' => $event->location,
            'location_type' => $event->location_type,
            'image' => $event->image,
            'start_date' => $event->start_date,
            'end_date' => $event->end_date,
            'start_date_tz' => DateHelper::formatApi($event->start_date),
            'end_date_tz' => DateHelper::formatApi($event->end_date),
            'registration_start' => $event->registration_start,
            'registration_end' => $event->registration_end,
            'max_participants' => $event->max_participants,
            'price' => $event->price,
            'currency' => $event->currency,
            //'available_seats' => $available_seats,
            //'has_available_seats' => $has_available_seats,
            'has_available_seats' => $event->hasAvailableSeats(),
            'available_seats' => $event->getAvailableSeats(),
            'registration_open' => $event->isRegistrationOpen(),
            'registration_count' => $event->getConfirmedRegistrations()->count(), //$registration_count,
            'meta_title' => $event->meta_title,
            'meta_description' => $event->meta_description,
            'meta_keywords' => $event->meta_keywords,
            'color' => $event->color,
            'date' => [
                'created' => DateHelper::formatApi($event->created_at),
                'updated' => DateHelper::formatApi($event->updated_at),
                'created_stamp' => $event->created_at,
                'updated_stamp' => $event->updated_at,
            ],
            'author' => $event->user->username,
            'auto_confirm' => $event->auto_confirm,
            'settings' => $event->settings ? json_decode($event->settings, true) : [],
            'notify_emails' => $event->getNotifyEmailsArray(),
        ];
    }

    public static function serializeListUsers(User $user): array
    {
        // get storage size
        return [
            'id' => $user->id,
            'username' => $user->username,
            'email' => $user->email,
            'avatar' => Yii::$app->request->hostInfo . Yii::$app->avatar->show($user->username . '_' . $user->id),
            'date' => [
                'created' => DateHelper::formatApi($user->created_at),
                'updated' => DateHelper::formatApi($user->updated_at),
                'created_stamp' => $user->created_at,
                'updated_stamp' => $user->updated_at,
            ],
            'status' => [
                'code' => $user->status
            ],
            'role' => array_keys(Yii::$app->authManager->getRolesByUser($user->id))[0],
            'bot' => [
                'tg_id' => $user->tg_id,
                'tg_code' => $user->tg_code,
            ],
            //'bot' => $user->bot,
            //'bot_data' => [
            //    'type' => $user->bot_data['type'] ?? null,
            //    'deck_id' => $user->bot_data['deck_id'] ?? null,
            //],
        ];
    }

    /**
     * Участник
     */
    public static function serializeMember(Member $member): array
    {
        $event = $member->event;

        return [
            'id' => $member->id,
            'event_id' => $member->event_id,
            'event' => $event ? [
                'id' => $event->id,
                'title' => $event->title,
                'slug' => $event->slug,
                'start_date' => $event->start_date,
                'start_date_formatted' => $event->start_date ? date('d.m.Y H:i', $event->start_date) : null,
            ] : null,
            'first_name' => $member->first_name,
            'last_name' => $member->last_name,
            'middle_name' => $member->middle_name,
            'full_name' => $member->getFullName(),
            'email' => $member->email,
            'phone' => $member->phone,
            'company' => $member->company,
            'position' => $member->position,
            'city' => $member->city,
            'country' => $member->country,
            'bio' => $member->bio,
            'photo' => $member->photo ? '/uploads/members/' . $member->photo : null,
            'documents' => $member->getDocumentsArray(),
            'status' => $member->status,
            'status_label' => Member::getStatuses()[$member->status] ?? 'Неизвестно',
            'form_data' => EventHelper::fieldsToCustomObjects($event, $member->getFormDataArray()),
            'notes' => $member->notes,
            'checked_in' => (bool)$member->isAttended(),
            'registered_at' => $member->registered_at,
            'registered_at_formatted' => date('d.m.Y H:i', $member->registered_at),
            'confirmed_at' => $member->confirmed_at,
            'confirmed_at_formatted' => $member->confirmed_at ? date('d.m.Y H:i', $member->confirmed_at) : null,
            'cancelled_at' => $member->cancelled_at,
            'cancelled_at_formatted' => $member->cancelled_at ? date('d.m.Y H:i', $member->cancelled_at) : null,
            'attended_at' => $member->attended_at,
            'attended_at_formatted' => $member->attended_at ? date('d.m.Y H:i', $member->attended_at) : null,
            'created_at' => $member->created_at,
            'created_at_formatted' => date('d.m.Y H:i', $member->created_at),
            'updated_at' => $member->updated_at,
            'updated_at_formatted' => date('d.m.Y H:i', $member->updated_at),
        ];
    }

    /**
     * Поле формы
     */
    public static function serializeEventField(EventField $field): array
    {
        return [
            'id' => $field->id,
            'event_id' => $field->event_id,
            'name' => $field->name,
            'label' => $field->label,
            'type' => $field->type,
            'type_label' => EventField::getTypes()[$field->type] ?? $field->type,
            'options' => $field->getOptionsArray(),
            'required' => (bool)$field->required,
            'sort_order' => $field->sort_order,
            'created_at' => $field->created_at,
            'created_at_formatted' => date('d.m.Y H:i', $field->created_at),
            'updated_at' => $field->updated_at,
            'updated_at_formatted' => date('d.m.Y H:i', $field->updated_at),
        ];
    }

}
