<?php

namespace app\core\helpers;

use app\core\entities\Settings;
use yii\db\Exception;

class SettingsHelper
{
    public static function getSetting($key, $default = null)
    {
        $setting = Settings::find()->andWhere(['key' => $key])->one();
        if ($setting) {
            return $setting->value;
        }
        return $default;
    }

    /**
     * @throws Exception
     */
    public static function setSetting($key, $value): void
    {
        $setting = Settings::find()->andWhere(['key' => $key])->one();
        if (!$setting) {
            $setting = new Settings();
            $setting->key = $key;
        }
        $setting->value = $value;
        $setting->save();
    }

    public static function hasModWL(): bool
    {
        $mods = json_decode(SettingsHelper::getSetting('shop.mods', '[]'), true);
        return in_array('mod_wl', $mods);
    }
}
