<?php

namespace app\core\helpers;

class StringHelper extends \yii\helpers\StringHelper
{
    public static function isValidTelegramToken($t): bool {
        return preg_match('/^\d{8,10}:[A-Za-z0-9_-]{35}$/', $t);
    }

    public static function detectCsvDelimiter($filePath)
    {
        $delimiters = [
            ',' => 0,
            ';' => 0,
            "\t" => 0,
            '|' => 0
        ];

        $lineCount = 0;

        if (($handle = fopen($filePath, "r")) !== FALSE) {
            // Анализируем первые 5 строк для точности
            for ($i = 0; $i < 5 && ($line = fgets($handle, 4096)) !== FALSE; $i++) {
                foreach ($delimiters as $delimiter => $count) {
                    $delimiters[$delimiter] += substr_count($line, $delimiter);
                }
                $lineCount++;
            }
            fclose($handle);
        }

        // Находим разделитель с максимальным количеством вхождений
        arsort($delimiters);
        $bestDelimiter = array_key_first($delimiters);

        // Если разделитель не найден (все нули), используем запятую по умолчанию
        return $delimiters[$bestDelimiter] > 0 ? $bestDelimiter : ',';
    }
}