<?php

namespace app\core\jobs;

use app\core\dispatchers\EventDispatcher;
use app\core\jobs\AsyncEventJob;

class AsyncEventJobHandler
{
    private EventDispatcher $dispatcher;

    public function __construct(EventDispatcher $dispatcher)
    {
        $this->dispatcher = $dispatcher;
    }

    public function handle(AsyncEventJob $job): void
    {
        $this->dispatcher->dispatch($job->event);
    }
}
