<?php

namespace app\core\jobs;

use Yii;
use yii\base\InvalidConfigException;
use yii\queue\JobInterface;

abstract class Job implements JobInterface
{
    /**
     * @throws InvalidConfigException
     */
    public function execute($queue): void
    {
        $listener = $this->resolveHandler();
        $listener($this, $queue);
    }

    /**
     * @throws InvalidConfigException
     */
    private function resolveHandler(): callable
    {
        return [Yii::createObject(static::class . 'Handler'), 'handle'];
    }
}
