<?php

namespace app\core\services;

use app\core\helpers\SettingsHelper;
use Symfony\Component\Mailer\Transport;

class MailTransportFactory
{
    /**
     * Создает транспорт из настроек БД
     */
    public static function createFromDb(): Transport\TransportInterface
    {
        // Получаем конфигурацию из БД
        $config = [
            'method' => SettingsHelper::getSetting('mail.method', 'sendmail'),
            'host' => SettingsHelper::getSetting('mail.smtp.host', ''),
            'port' => SettingsHelper::getSetting('mail.smtp.port', '587'),
            'username' => SettingsHelper::getSetting('mail.smtp.username', ''),
            'password' => SettingsHelper::getSetting('mail.smtp.password', ''),
            'encryption' => SettingsHelper::getSetting('mail.encryption', 'tls'),
            //'timeout' => 10000,

        ];

        // Создаем DSN для Symfony Mailer
        $dsn = self::buildDsn($config);

        // Создаем транспорт
        return Transport::fromDsn($dsn);
    }

    /**
     * Строит DSN строку для Symfony Mailer
     */
    protected static function buildDsn( $config): string
    {
        // Пример: smtp://user:pass@host:port?encryption=tls&timeout=30
        if ($config['method'] === 'sendmail') {
            return 'sendmail://default';
        }

        $dsn = $config['method'] . '://';

        if (!empty($config['username'])) {
            $dsn .= urlencode($config['username']);
            if (!empty($config['password'])) {
                $dsn .= ':' . urlencode($config['password']);
            }
            $dsn .= '@';
        }

        $dsn .= $config['host'];

        if (!empty($config['port'])) {
            $dsn .= ':' . $config['port'];
        }

        // Добавляем параметры
        $params = [];
        if (!empty($config['encryption'])) {
            $params['encryption'] = $config['encryption'];
        }
        $params['verify_peer'] = '0';
        //if (!empty($config['timeout'])) {
        //    $params['timeout'] = $config['timeout'];
        //}
        //if (!empty($config['local_domain'])) {
        //    $params['local_domain'] = $config['local_domain'];
        //}

        if (!empty($params)) {
            $dsn .= '?' . http_build_query($params);
        }

        return $dsn;
    }
}
