Вот примеры ответов сервера для каждого эндпоинта:

1. Проверка наличия обновлений
> GET /api/update/check
```json
{
    "success": true,
    "data": {
        "current_version": "2025-1-0-0",
        "last_check": "2025-01-15 10:30:45",
        "has_updates": true,
        "update_in_progress": false
    }
}
```
Или если обновление идет:
```json
{
    "success": true,
    "data": {
        "current_version": "2025-1-0-0",
        "last_check": "2025-01-15 10:30:45",
        "has_updates": false,
        "update_in_progress": true
    }
}
```
2. Получение доступных обновлений
>    POST /update.php [current_version = 2025-1-1-0]
```json
{
  "success": true,
  "data": {
      "updates": [
          "2025-1-0-1",
          "2025-1-0-2",
          "2025-1-1-0",
          "2025-1-1-1",
          "2025-1-2-0"
      ]
  }
}
```
Если нет обновлений:
```json
{
    "success": true,
    "data": {
        "current_version": "2025-1-2-0",
        "available_updates": [],
        "update_chain": [],
        "latest_version": "2025-1-2-0",
        "can_update": false
    }
}
```
3. Статус обновления
> GET /api/update/status
 
Когда обновление не идет:
```
json{
    "success": true,
    "data": {
        "current_version": "2025-1-0-0",
        "has_pending_request": false,
        "update_in_progress": false,
        "last_check": "2025-01-15 10:30:45"
    }
}
```
Когда обновление идет:
```json
{
    "success": true,
    "data": {
        "current_version": "2025-1-0-0",
        "has_pending_request": true,
        "update_in_progress": true,
        "last_check": "2025-01-15 10:30:45",
        "progress": {
            "started_at": "2025-01-15 10:35:20",
            "pid": 12345,
            "current_chain": ["2025-1-0-1", "2025-1-0-2", "2025-1-1-0"],
            "current_step": 1,
            "total_steps": 3,
            "status": "in_progress",
            "progress_percent": 33,
            "elapsed_seconds": 65
        }
    }
}
```
При ошибке обновления:
```json
{
    "success": true,
    "data": {
        "current_version": "2025-1-0-1",
        "has_pending_request": false,
        "update_in_progress": true,
        "last_check": "2025-01-15 10:30:45",
        "progress": {
            "started_at": "2025-01-15 10:35:20",
            "finished_at": "2025-01-15 10:36:10",
            "pid": 12345,
            "status": "failed",
            "error": "Не удалось применить миграцию 002_add_new_column.sql",
            "failed_at_version": "2025-1-0-1"
        },
        "failed": true,
        "error": "Не удалось применить миграцию 002_add_new_column.sql"
    }
}
```
4. Запрос на обновление
>POST /api/update/request

Без указания версии (до последней):
```json
{
    "success": true,
    "message": "Запрос на обновление до версии 2025-1-2-0 отправлен",
    "data": {
        "target_version": "2025-1-2-0",
        "current_version": "2025-1-0-0",
        "update_chain": ["2025-1-0-1", "2025-1-0-2", "2025-1-1-0", "2025-1-1-1", "2025-1-2-0"]
    }
}
```
С указанием версии:
```json
{
    "success": true,
    "message": "Запрос на обновление до версии 2025-1-1-0 отправлен",
    "data": {
        "target_version": "2025-1-1-0",
        "current_version": "2025-1-0-0"
    }
}
```
Ошибки:
```json
{
    "success": false,
    "error": "Обновление уже выполняется"
}
```
```json
{
    "success": false,
    "error": "Нет доступных обновлений"
}
```
```json
{
    "success": false,
    "error": "Целевая версия должна быть больше текущей"
}
```
5. История обновлений
> GET /api/update/history
```json
{
    "success": true,
    "data": {
        "history": [
            {
                "file": "2025-01-14_143025_2025-1-1-0-from-2025-1-0-2.zip",
                "applied_at": "2025-01-14 14:30:25",
                "from_version": "2025-1-0-2",
                "to_version": "2025-1-1-0",
                "size": 2457600
            },
            {
                "file": "2025-01-13_092015_2025-1-0-2-from-2025-1-0-1.zip",
                "applied_at": "2025-01-13 09:20:15",
                "from_version": "2025-1-0-1",
                "to_version": "2025-1-0-2",
                "size": 1835008
            },
            {
                "file": "2025-01-12_161045_2025-1-0-1-from-2025-1-0-0.zip",
                "applied_at": "2025-01-12 16:10:45",
                "from_version": "2025-1-0-0",
                "to_version": "2025-1-0-1",
                "size": 1572864
            }
        ],
        "total": 3
    }
}
```   
   Пустая история:
```json
{
    "success": true,
    "data": {
        "history": [],
        "total": 0
    }
}
```
6. Отмена обновления
> POST /api/update/cancel

   Успех:
```json
{
    "success": true,
    "message": "Запрос на обновление отменен"
}
```
Ошибка:
```json
{
    "success": false,
    "error": "Нет активных запросов на обновление"
}
```
7. Принудительная проверка
> POST /api/update/force-check
```json
{
    "success": true,
    "data": {
        "current_version": "2025-1-0-0",
        "available_updates": ["2025-1-0-1", "2025-1-0-2", "2025-1-1-0"],
        "has_updates": true,
        "checked_at": "2025-01-15 10:40:30"
    }
}
```   
8. Формат версий и цепочек
> Пример полной цепочки обновлений:
```json
{
    "from": "2025-1-0-0",
    "to": "2025-1-2-3",
    "chain": [
        "2025-1-0-1",
        "2025-1-0-2",
        "2025-1-1-0",
        "2025-1-1-1",
        "2025-1-1-2",
        "2025-1-2-0",
        "2025-1-2-1",
        "2025-1-2-2",
        "2025-1-2-3"
    ],
    "total_steps": 9
}
```   
   Пример прогресса для шага 3 из 9: 
> Индексация **current_step** с 0
```json
{
    "current_step": 2,
    "total_steps": 9,
    "progress_percent": 33,
    "current_from": "2025-1-0-2",
    "current_to": "2025-1-1-0",
    "next_from": "2025-1-1-0",
    "next_to": "2025-1-1-1"
}
```   
9. Ошибки авторизации/доступа
```json
{
    "success": false,
    "error": "Требуется авторизация"
}
```
```json
{
    "success": false,
    "error": "Требуются права: admin или systemAdmin"
}
```   
10. Общий формат ошибок API
```json
{
    "success": false,
    "error": "Описание ошибки",
    "code": "ERROR_CODE_OPTIONAL",
    "details": {
        "field": "Дополнительные детали",
        "timestamp": "2025-01-15T10:30:45Z"
    }
}
```    
### Пример реального сценария:
#### Шаг 1: Пользователь заходит в систему
> GET /api/update/check
```json
{
    "success": true,
    "data": {
        "current_version": "2025-1-0-0",
        "last_check": "2025-01-15 09:00:00",
        "has_updates": true,
        "update_in_progress": false
    }
}
```    
#### Шаг 2: Пользователь нажимает "Проверить обновления"
> GET /api/update/available
```json
{
    "success": true,
    "data": {
        "current_version": "2025-1-0-0",
        "available_updates": ["2025-1-0-1", "2025-1-0-2", "2025-1-1-0"],
        "latest_version": "2025-1-1-0",
        "can_update": true
    }
}
```    
#### Шаг 3: Пользователь запускает обновление
> POST /api/update/request
```json
{
    "success": true,
    "message": "Запрос на обновление до версии 2025-1-1-0 отправлен",
    "data": {
        "target_version": "2025-1-1-0",
        "current_version": "2025-1-0-0",
        "update_chain": ["2025-1-0-1", "2025-1-0-2", "2025-1-1-0"]
    }
}
```    
#### Шаг 4: Система периодически проверяет статус
> GET /api/update/status (через 5 секунд)
```json
{
    "success": true,
    "data": {
        "current_version": "2025-1-0-0",
        "update_in_progress": true,
        "progress": {
            "current_step": 0,
            "total_steps": 3,
            "progress_percent": 0,
            "status": "in_progress"
        }
    }
}
```
> GET /api/update/status (через 30 секунд)
```json
{
"success": true,
"data": {
"current_version": "2025-1-0-1",
"update_in_progress": true,
"progress": {
"current_step": 1,
"total_steps": 3,
"progress_percent": 33,
"status": "in_progress"
}
}
}
```
>GET /api/update/status (после завершения)
```json
{
    "success": true,
    "data": {
        "current_version": "2025-1-1-0",
        "update_in_progress": false,
        "has_pending_request": false
    }
}