<?php

namespace app\core\services\update;

use Yii;

class ExclusionManager
{
    private $config;

    public function __construct()
    {
        $this->loadConfig();
    }

    public function getExclusions()
    {
        return $this->config;
    }

    public function validateConfig(): array
    {
        $errors = [];

        // Проверяем существование исключенных папок
        foreach ($this->config['directories'] ?? [] as $dir) {
            $fullPath = Yii::getAlias($dir);
            if (!is_dir($fullPath)) {
                $errors[] = "Excluded directory does not exist: {$dir}";
            }
        }

        // Проверяем валидность regex паттернов
        foreach ($this->config['patterns'] ?? [] as $pattern) {
            if (@preg_match($pattern, '') === false) {
                $errors[] = "Invalid regex pattern: {$pattern}";
            }
        }

        return $errors;
    }

    private function loadConfig(): void
    {
        //$configFile = __DIR__ . '/../config/exclude.php';
        $configFile = Yii::getAlias('@app/core/services/update/exclude.php');

        if (file_exists($configFile)) {
            $this->config = require $configFile;
        } else {
            // Конфиг по умолчанию
            $this->config = $this->getDefaultExclusions();
        }
    }

    private function getDefaultExclusions(): array
    {
        return [
            'directories' => [
                '@app/vue3',
                '@app/runtime',
            ],
            'files' => [
                '@app/composer.json',
            ],
            'patterns' => [
                //'/\.(vue|js|log|sqlite|backup)$/i', // Расширения
                //'/^(config\/|tests\/)/',            // Папки
                //'/_(test|old|backup)\.php$/i',      // Паттерны файлов
            ],
        ];
    }
}