<?php
namespace app\core\services\update;

use Yii;

class MigrationCollector
{
    public function getMigrationsBetween($fromVersion, $toVersion): array
    {
        $migrationDir = Yii::getAlias('@app/migrations');
        $migrations = [];

        if (!is_dir($migrationDir)) {
            return $migrations;
        }

        // Получаем все SQL файлы
        $files = glob($migrationDir . '/*.sql');

        foreach ($files as $file) {
            $filename = basename($file);

            // Парсим дату из имени файла (формат: mYYMMDD_HHMMSS_name.sql)
            if (preg_match('/^m(\d{6}_\d{6})_/', $filename, $matches)) {
                $timestamp = $matches[1];

                // Здесь логика фильтрации по версиям
                // Можно хранить связь версий с timestamp в отдельном файле
                $migrations[] = $filename;
            }
        }

        sort($migrations);
        return $migrations;
    }
}