<?php

use app\core\entities\Event;
use app\core\entities\Member;
use yii\helpers\Html;
use yii\web\View;

/**
 * @var $this View
 * @var $html string
 * @var $text string
 * @var $member Member
 * @var $event Event
 * @var $notify string
 */

$start = date('d.m.Y H:i', $event->start_date);
$end = date('d.m.Y H:i', $event->end_date);
$period = $start == $end ? $start . ' - ' . $end : $start;

$location = $event->location_type == Event::LOCATION_ONLINE
        ? 'Ссылка: <a href="' . $event->location . '">' . $event->location
        : 'Адрес: ' . Html::encode($event->location);

$link = Yii::$app->params['generalDomain'];
?>

Здравствуйте, <?= Html::encode($member->getFullName()) ?>!
<br><br>
Благодарим вас за регистрацию на <?= Event::getTypes()[$event->type] ?><br>
<b><?= Html::encode($event->title) ?></b>.
<br><br>
О мероприятии<br><br>
Дата: <?= $period ?><br><br>
<?= $location ?><br><br>

<?= Yii::$app->formatter->asNtext($notify); ?>
