<?php

use yii\helpers\Html;
use yii\web\View;
use app\core\entities\Event;
use app\core\entities\Member;

/**
 * @var $this View
 * @var $html string
 * @var $text string
 * @var $member Member
 * @var $event Event
 * @var $notify string
 */

$start = date('d.m.Y H:i', $event->start_date);
$end = date('d.m.Y H:i', $event->end_date);
$period = $start == $end ? $start . ' - ' . $end : $start;

$location = $event->location_type == Event::LOCATION_ONLINE
        ? 'Ссылка: <a href="' . $event->location . '">' . $event->location
        : 'Адрес: ' . $event->location;

$link = Yii::$app->params['generalDomain'];
?>

Здравствуйте, <?= $member->getFullName() ?>!

Благодарим вас за регистрацию на <?= Event::getTypes()[$event->type] ?>
<?= $event->title ?>.

О мероприятии:
Дата: <?= $period ?>
<?= $location ?>

<?= $notify ?>
