<?php

use app\core\entities\Event;
use app\core\entities\Member;
use app\core\helpers\EventHelper;
use yii\helpers\Html;
use yii\web\View;

/**
 * @var $this View
 * @var $html string
 * @var $text string
 * @var $member Member
 * @var $event Event
 */

$fields = EventHelper::fieldsToCustomObjects($event, $member->getFormDataArray());

$link = Yii::$app->params['generalDomain'];
?>

Здравствуйте!
<br><br>
Новая регистрация на мероприятие:<br>
<b><?= Html::encode($event->title) ?></b>
<br><br>
Имя: <?= Html::encode($member->getFullName()) ?><br>
E-mail: <?= Html::encode($member->email ?: 'не указан') ?><br>
Телефон: <?= Html::encode($member->phone ?: 'не указан') ?><br>
Компания: <?= Html::encode($member->company ?: 'не указан') ?><br>
Должность: <?= Html::encode($member->position ?: 'не указан') ?><br>
Страна: <?= Html::encode($member->country ?: 'не указан') ?><br>
Город: <?= Html::encode($member->city ?: 'не указан') ?><br>
<br><br>

<?php foreach ($fields as $field): ?>
<?php if ($field['value']): ?>
<?= $field['label'] ?>: <?= Html::encode($field['value']) ?><br>
<?php endif; ?>
<?php endforeach; ?>
