<?php

use app\core\helpers\EventHelper;
use yii\helpers\Html;
use yii\web\View;
use app\core\entities\Event;
use app\core\entities\Member;

/**
 * @var $this View
 * @var $html string
 * @var $text string
 * @var $member Member
 * @var $event Event
 */

$fields = EventHelper::fieldsToCustomObjects($event, $member->getFormDataArray());

$link = Yii::$app->params['generalDomain'];
?>

Здравствуйте!

Новая регистрация на мероприятие:
<?= Html::encode($event->title) ?>

Имя: <?= Html::encode($member->getFullName()) ?>
E-mail: <?= Html::encode($member->email ?: 'не указан') ?>
Телефон: <?= Html::encode($member->phone ?: 'не указан') ?>
Компания: <?= Html::encode($member->company ?: 'не указан') ?>
Должность: <?= Html::encode($member->position ?: 'не указан') ?>
Страна: <?= Html::encode($member->country ?: 'не указан') ?>
Город: <?= Html::encode($member->city ?: 'не указан') ?>

<?php foreach ($fields as $field): ?>
    <?= $field['label'] ?>: <?= Html::encode($field['value']) ?>
<?php endforeach; ?>