<?php
use app\core\db\UuidTypeTrait;
use yii\db\Migration;

/**
 * Handles the creation of table `{{%users}}`.
 */
class m220621_151741_create_users_table extends Migration
{
    use UuidTypeTrait;

    /**
     * {@inheritdoc}
     * @throws \yii\base\Exception
     */
    public function safeUp(): void
    {
        $this->createTable('{{%users}}', [
            'id' => $this->uuid(),
            'username' => $this->string(100),
            'auth_key' => $this->string(32)->notNull(),
            'password_hash' => $this->string(255)->notNull(),
            'password_reset_token' => $this->string(100)->unique(),
            'email' => $this->string(150)->notNull()->unique(),
            'email_confirm_token' => $this->string(100)->unique(),
            'status' => $this->smallInteger()->notNull()->defaultValue(10),
            'settings' => $this->json()->null(),
            'allowance' => $this->integer(),
            'allowance_updated_at' => $this->bigInteger(),
            'tg_id' => $this->bigInteger()->null()->unique(),
            'tg_access' => $this->boolean()->null()->defaultValue(false),
            'tg_expired' => $this->bigInteger()->null(),
            'tg_code' => $this->string(50)->null(),
            'user_pic' => $this->string(500)->null(),
            'created_at' => $this->bigInteger()->notNull(),
            'updated_at' => $this->bigInteger()->notNull(),
        ]);

        $this->addPrimaryKey('pk-users', '{{%users}}', 'id');
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown(): void
    {
        $this->dropTable('{{%users}}');
    }
}
