<?php
use yii\db\Migration;

/**
 * Class m220621_151743_add_user_roles
 */
class m220621_151743_add_user_roles extends Migration
{
    public function safeUp(): void
    {
        $this->batchInsert('{{%auth_item}}', ['type', 'name', 'description'], [
            [1, 'user', 'Пользователь'],
            [1, 'manager', 'Менеджер'],
            [1, 'admin', 'Администратор'],
        ]);

        $this->batchInsert('{{%auth_item_child}}', ['parent', 'child'], [
            ['admin', 'manager'],
            ['manager', 'user'],
        ]);

        $this->execute('INSERT INTO {{%auth_assignment}} (item_name, user_id) SELECT \'user\', u.id FROM {{%users}} u ORDER BY u.id');
    }

    public function down(): void
    {
        $this->delete('{{%auth_item}}', ['name' => ['user', 'manager', 'admin']]);
    }
}
