<?php

use app\core\db\UuidTypeTrait;
use yii\db\Migration;

/**
 * Handles the creation of table `{{%events}}`.
 */
class m251208_051134_create_events_table extends Migration
{
    use UuidTypeTrait;

    /**
     * {@inheritdoc}
     */
    public function safeUp(): void
    {
        $this->createTable('{{%events}}', [
            'id' => $this->uuid(),
            'user_id' => $this->uuid(),
            'title' => $this->string(255)->notNull(),
            'slug' => $this->string(255)->notNull()->unique(),
            'description' => $this->text(),
            'short_description' => $this->string(500),
            'content' => $this->json()->null(), // для структурированного контента
            'status' => $this->smallInteger()->notNull()->defaultValue(10),
            'type' => $this->string(50)->notNull()->defaultValue('event'), // event, webinar, workshop etc
            'location_type' => $this->string(50)->defaultValue('online'), // online, offline, hybrid
            'location' => $this->string(500), // физический адрес или ссылка
            'image' => $this->string(500),
            'start_date' => $this->bigInteger()->defaultValue(0), // timestamp
            'end_date' => $this->bigInteger()->defaultValue(0), // timestamp
            'registration_start' => $this->bigInteger()->defaultValue(0), // когда открывается регистрация
            'registration_end' => $this->bigInteger()->defaultValue(0), // когда закрывается регистрация
            'max_participants' => $this->integer()->defaultValue(0), // ограничение участников
            'price' => $this->decimal(10, 2)->defaultValue(0),
            'currency' => $this->string(3)->defaultValue('RUB'),
            'settings' => $this->json()->null(), // дополнительные настройки
            'meta_title' => $this->string(255),
            'meta_description' => $this->string(500),
            'meta_keywords' => $this->string(500),
            'created_at' => $this->bigInteger()->notNull(),
            'updated_at' => $this->bigInteger()->notNull(),
        ]);

        $this->addPrimaryKey('pk-events', '{{%events}}', 'id');

        // Индексы для быстрого поиска
        $this->createIndex('idx-events-slug', '{{%events}}', 'slug');
        $this->createIndex('idx-events-status', '{{%events}}', 'status');
        $this->createIndex('idx-events-start_date', '{{%events}}', 'start_date');
        $this->createIndex('idx-events-type', '{{%events}}', 'type');
        $this->createIndex('idx-events-user', '{{%events}}', 'user_id');

        // Внешние ключи
        $this->addForeignKey(
            'fk-events-user',
            '{{%events}}',
            'user_id',
            '{{%users}}',
            'id',
            'SET NULL',
            'CASCADE'
        );
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown(): void
    {
        $this->dropForeignKey('fk-events-user', '{{%events}}');
        $this->dropTable('{{%events}}');
    }
}
