<?php

use app\core\db\UuidTypeTrait;
use yii\db\Migration;

class m251209_120743_create_members_table extends Migration
{
    use UuidTypeTrait;

    public function safeUp(): void
    {
        $this->createTable('{{%members}}', [
            'id' => $this->uuid(),
            'event_id' => $this->uuid()->notNull(),

            // Основные данные (было в contacts)
            'first_name' => $this->string(100)->notNull(),
            'last_name' => $this->string(100)->notNull(),
            'middle_name' => $this->string(100),
            'email' => $this->string(255),
            'phone' => $this->string(50),
            'company' => $this->string(255),
            'position' => $this->string(255),
            'city' => $this->string(100),
            'country' => $this->string(100),
            'bio' => $this->text(), // из members
            'documents' => $this->json()->null(), // из members

            // Фото (было в members)
            'photo' => $this->string(500),

            // Статус (было в members)
            'status' => $this->smallInteger()->notNull()->defaultValue(0),

            // Данные из registration
            'form_data' => $this->json()->null(),
            'notes' => $this->text(),
            'registration_ip' => $this->string(45),
            'user_agent' => $this->text(),
            'registered_at' => $this->bigInteger()->notNull(),
            'confirmed_at' => $this->bigInteger(),
            'cancelled_at' => $this->bigInteger(),
            'attended_at' => $this->bigInteger(),
            //'checkin_code' => $this->string(50)->unique(),
            'settings' => $this->json()->null(),

            // Timestamps
            'created_at' => $this->bigInteger()->notNull(),
            'updated_at' => $this->bigInteger()->notNull(),
        ]);

        $this->addPrimaryKey('pk-members', '{{%members}}', 'id');
        $this->createIndex('idx-members-event', '{{%members}}', 'event_id');
        $this->createIndex('idx-members-status', '{{%members}}', ['event_id', 'status']);
        $this->createIndex('idx-members-email', '{{%members}}', 'email');
        //$this->createIndex('idx-members-checkin-code', '{{%members}}', 'checkin_code');

        $this->addForeignKey(
            'fk-members-event',
            '{{%members}}',
            'event_id',
            '{{%events}}',
            'id',
            'CASCADE',
            'CASCADE'
        );
    }

    public function safeDown(): void
    {
        $this->dropForeignKey('fk-members-event', '{{%members}}');
        $this->dropTable('{{%members}}');
    }
}
