<?php

use app\core\db\UuidTypeTrait;
use yii\db\Migration;

class m251209_121039_create_event_fields_table extends Migration
{
    use UuidTypeTrait;

    public function safeUp(): void
    {
        $this->createTable('{{%event_fields}}', [
            'id' => $this->uuid(),
            'event_id' => $this->uuid()->notNull(),
            'name' => $this->string(100)->notNull(),
            'label' => $this->string(255)->notNull(),
            'type' => $this->string(50)->notNull()->defaultValue('text'),
            'options' => $this->json()->null(),
            'required' => $this->boolean()->defaultValue(false),
            'sort_order' => $this->integer()->defaultValue(0),
            'created_at' => $this->bigInteger()->notNull(),
            'updated_at' => $this->bigInteger()->notNull(),
        ]);

        $this->addPrimaryKey('pk-event_fields', '{{%event_fields}}', 'id');
        $this->createIndex('idx-event_fields-event', '{{%event_fields}}', 'event_id');

        $this->addForeignKey(
            'fk-event_fields-event',
            '{{%event_fields}}',
            'event_id',
            '{{%events}}',
            'id',
            'CASCADE',
            'CASCADE'
        );
    }

    public function safeDown(): void
    {
        $this->dropForeignKey('fk-event_fields-event', '{{%event_fields}}');
        $this->dropTable('{{%event_fields}}');
    }
}
