<?php

use yii\db\Migration;

/**
 * Handles the creation of table `{{%settings}}`.
 */
class m251211_100501_create_settings_table extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp(): void
    {
        $this->createTable('{{%settings}}', [
            'key' => $this->string(100)->notNull()->unique(),
            'value' => $this->text(),
        ]);

        $this->addPrimaryKey('pk-settings-key', '{{%settings}}', 'key');
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown(): void
    {
        $this->dropTable('{{%settings}}');
    }
}
