<?php

use yii\db\Migration;

class m251221_103304_add_login_tokens_fields extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp(): void
    {
        $this->addColumn('{{%users}}', 'login_token', $this->string(64));
        $this->addColumn('{{%users}}', 'login_token_at', $this->bigInteger()->defaultValue(0));

        $this->createIndex('users_login_token', '{{%users}}', ['login_token', 'login_token_at']);
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown(): void
    {
        $this->dropIndex('users_login_token', '{{%users}}');

        $this->dropColumn('{{%users}}', 'login_token_at');
        $this->dropColumn('{{%users}}', 'login_token');
    }
}
